<?php

namespace Intergo\WhatsappApiClient;


use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class WhatsappApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        'getUserSettings' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-settings', self::INTERNAL => true],
        'enableUserSettings' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user-settings', self::INTERNAL => true],
        'updateUserSettings' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/user-settings/:id', self::INTERNAL => true],
        'deleteUserSettings' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/user-settings/:id', self::INTERNAL => true],
        'processAlarisResponse' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/provider-callback/alaris', self::INTERNAL => true],
        'processGupshupResponse' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/provider-callback/gupshup', self::INTERNAL => true],
        'getGupShupApplications' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/gupshup-settings/applications', self::INTERNAL => true],
        'getGupShupApplicationTemplates' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/gupshup-settings/application/:id/templates', self::INTERNAL => true],
    ];


}