<?php

namespace Intergo\WhatsappApiClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;
use Intergo\ViberApiClient\ViberApiClient;

abstract class AbstractWhatsappApiService
{

    private WhatsappApiCLient $client;

    public function __construct(string $baseUrl, string $traceId)
    {
        $this->client = new WhatsappApiClient($baseUrl, $traceId);
    }

    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    /**
     * @param int $user_id
     * @return BaseResponseInterface
     */
    public function getUserSettings(int $user_id): BaseResponseInterface
    {
        $urlParams = [
            'user_id' => $user_id,
        ];
        return $this->execute(__FUNCTION__, [], $urlParams);

    }

    /**
     * @param $user_id
     * @param $is_enabled
     * @param $source
     * @param $template
     * @param $sender_id
     * @return BaseResponseInterface
     */
    public function enableUserSettings($user_id, $is_enabled, $source, $template, $sender_id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], compact('user_id', 'is_enabled', 'source', 'template', 'sender_id'));
    }

    /**
     * @param $id
     * @param $user_id
     * @param $is_enabled
     * @param $source
     * @param $template
     * @param $sender_id
     * @return BaseResponseInterface
     */
    public function updateUserSettings($id, $user_id, $is_enabled, $source, $template, $sender_id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, compact('id'), compact('user_id', 'is_enabled', 'source', 'template', 'sender_id'));
    }

    /**
     * @param $id
     * @return BaseResponseInterface
     */
    public function deleteUserSettings($id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, compact('id'));
    }

    /**
     * @param array $messageParams
     * @return BaseResponseInterface
     */
    public function processAlarisResponse(array $messageParams): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $messageParams);
    }


    /**
     * @param array $messageParams
     * @return BaseResponseInterface
     */
    public function processGupshupResponse(array $messageParams): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $messageParams);
    }

    /**
     * @return BaseResponseInterface
     */
    public function getGupShupApplications()
    {
        return $this->execute(__FUNCTION__);

    }

    /**
     * @param $id
     * @return BaseResponseInterface
     */
    public function getGupShupApplicationTemplates($id)
    {
        return $this->execute(__FUNCTION__, compact('id'));

    }

}
