<?php

namespace Intergo\WhatsappApiClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;
use Intergo\ViberApiClient\ViberApiClient;

abstract class AbstractWhatsappApiService
{

    private WhatsappApiCLient $client;

    public function __construct(string $baseUrl, string $traceId)
    {
        $this->client = new WhatsappApiClient($baseUrl, $traceId);
    }

    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    /**
     * @param string $user_id
     * @param string $sender_id
     * @return BaseResponseInterface
     */
    public function getUserCountryProviderList(string $user_id, string $sender_id): BaseResponseInterface
    {
        $bodyParams = [
            'user_id' => $user_id,
            'sender_id' => $sender_id,
        ];
        return $this->execute(__FUNCTION__, [], $bodyParams);
    }

    /**
     * @param int $userSettingsId
     * @param string $mcc
     * @param string $provider
     * @param string $productId
     * @param string $template
     * @param string $source
     * @param string $applicationId
     * @param string $applicationName
     * @param string $templateName
     * @param int $ttl
     * @return BaseResponseInterface
     */
    public function addUserCountryProvider(int $userSettingsId, string $mcc, string $provider, string $productId, string $template, string $source, string $applicationId, string $applicationName, string $templateName, int $ttl): BaseResponseInterface
    {
        $urlParams = [
            'userSettingsId' => $userSettingsId
        ];
        $bodyParams = [
            'mcc' => $mcc,
            'provider' => $provider,
            'product_id' => $productId,
            'template' => $template,
            'source' => $source,
            'application_id' => $applicationId,
            'application_name' => $applicationName,
            'template_name' => $templateName,
            'ttl' => $ttl,
        ];
        return $this->execute(__FUNCTION__, $urlParams, $bodyParams);
    }

    /**
     * @param int $id
     * @return BaseResponseInterface
     */
    public function getUserCountryProvider(int $id): BaseResponseInterface
    {
        $urlParams = [
            'id' => $id
        ];
        return $this->execute(__FUNCTION__, $urlParams, []);
    }

    /**
     * @param int $id
     * @param string $mcc
     * @param string $provider
     * @param string $productId
     * @param string $template
     * @param string $source
     * @param string $applicationId
     * @param string $applicationName
     * @param string $templateName
     * @param int $ttl
     * @return BaseResponseInterface
     */
    public function updateUserCountryProvider(int $id, string $mcc, string $provider, string $productId, string $template, string $source, string $applicationId, string $applicationName, string $templateName, int $ttl): BaseResponseInterface
    {
        $urlParams = [
            'id' => $id
        ];
        $bodyParams = [
            'mcc' => $mcc,
            'provider' => $provider,
            'product_id' => $productId,
            'template' => $template,
            'source' => $source,
            'application_id' => $applicationId,
            'application_name' => $applicationName,
            'template_name' => $templateName,
            'ttl' => $ttl,
        ];
        return $this->execute(__FUNCTION__, $urlParams, $bodyParams);
    }

    /**
     * @param int $id
     * @return BaseResponseInterface
     */
    public function deleteUserCountryProvider(int $id): BaseResponseInterface
    {
        $urlParams = [
            'id' => $id
        ];
        return $this->execute(__FUNCTION__, $urlParams);
    }

    /**
     * @param int $user_id
     * @return BaseResponseInterface
     */
    public function getUserSettings(int $user_id): BaseResponseInterface
    {
        $urlParams = [
            'user_id' => $user_id,
        ];
        return $this->execute(__FUNCTION__, [], $urlParams);

    }

    /**
     * @param $user_id
     * @param $is_enabled
     * @param $source
     * @param $template
     * @param $sender_id
     * @param $application_id
     * @param $application_name
     * @param $template_name
     * @param $ttl
     * @param $default_provider
     * @return BaseResponseInterface
     */
    public function enableUserSettings($user_id, $is_enabled, $source, $template, $sender_id,$application_id,$application_name,$template_name,$ttl,$default_provider): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], compact('user_id', 'is_enabled', 'source', 'template', 'sender_id','application_id','application_name','template_name','ttl','default_provider'));
    }

    /**
     * @param $id
     * @param $user_id
     * @param $is_enabled
     * @param $source
     * @param $template
     * @param $sender_id
     * @param $application_id
     * @param $application_name
     * @param $template_name
     * @param $ttl
     * @param $default_provider
     * @return BaseResponseInterface
     */
    public function updateUserSettings($id, $user_id, $is_enabled, $source, $template, $sender_id,$application_id,$application_name,$template_name,$ttl,$default_provider): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, compact('id'), compact('user_id', 'is_enabled', 'source', 'template', 'sender_id','application_id','application_name','template_name','ttl','default_provider'));
    }

    /**
     * @param $id
     * @return BaseResponseInterface
     */
    public function deleteUserSettings($id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, compact('id'));
    }

    /**
     * @param array $messageParams
     * @return BaseResponseInterface
     */
    public function processAlarisResponse(array $messageParams): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $messageParams);
    }


    /**
     * @param array $messageParams
     * @return BaseResponseInterface
     */
    public function processGupshupResponse(array $messageParams): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $messageParams);
    }

    /**
     * @return BaseResponseInterface
     */
    public function getGupShupApplications()
    {
        return $this->execute(__FUNCTION__);

    }

    /**
     * @param $id
     * @return BaseResponseInterface
     */
    public function getGupShupApplicationTemplates($id)
    {
        return $this->execute(__FUNCTION__, compact('id'));

    }

}
