<?php

use Intergo\BaseClient\Responses\BaseResponseInterface;
use Intergo\WhatsappApiClient\WhatsappApiClient;

abstract class AbstractWhatsappApiService
{

    private WhatsappApiCLient  $client;

    public function __construct(WhatsappApiClient $client){
        $this->client = $client;
    }
    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }
    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    public function getUserSettings(int $user_id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], compact('user_id'));

    }

}