<?php

namespace Intergo\WhatsappApiClient;


use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class WhatsappApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        'getUserSettings' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-settings', self::INTERNAL => true],
        'enableUserSettings' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user-settings', self::INTERNAL => true],
        'updateUserSettings' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/user-settings/:id', self::INTERNAL => true],
        'processAlarisResponse' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/provider-callback/alaris', self::INTERNAL => true],

    ];


}