<?php

namespace Intergo\WhatsappApiClient\Jobs;

use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Intergo\CommonSending\DataTransferObjects\ViberMessageDTO;
use Intergo\CommonSending\DataTransferObjects\WhatsAppMessageDTO;

class BaseSendWhatsAppJob implements ShouldQueue
{

    use Batchable, InteractsWithQueue, Queueable, SerializesModels;
    protected string $trace_id;
    public int $priority = 3;
    protected WhatsAppMessageDTO $message;

    /**
     * Constructor to assign data
     *
     * @param WhatsAppMessageDTO $message
     * @param int $priority
     * @param string $traceId
     */
    public function __construct(WhatsAppMessageDTO $message, int $priority, string $traceId)
    {
        $this->trace_id = $traceId;
        $this->message = $message;
        $this->priority = $priority;
    }

    /**
     * @return void
     */
    public function handle()
    {
        //
    }

}
