<?php

namespace Intergo\ViberApiClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractViberApiService
{
    private ViberApiClient $client;

    /**
     * ViberApiService constructor.
     *
     * @param string $baseUrl
     * @param string $traceId
     */
    public function __construct(string $baseUrl, string $traceId)
    {
        $this->client = new ViberApiClient($baseUrl, $traceId);
    }

    /**
     * @param string $endpoint
     * @param array $urlParams
     * @param array $bodyParams
     * @return BaseResponseInterface
     */
    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    /**
     * @param array $messageData
     * @return BaseResponseInterface
     */
    public function sendMessage(array $messageData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $messageData);
    }

    /**
     * Retrieves user settings based on the user_id given
     *
     * @param string $user_id The userId to be retrieved.
     * @return BaseResponseInterface
     */
    public function getUserSettings(string $user_id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], compact('user_id'));
    }

    /**
     * @param array $userSettings
     * @return BaseResponseInterface
     */
    public function storeUserSettings(array $userSettings): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $userSettings);
    }

    /**
     * @param $id
     * @return BaseResponseInterface
     */
    public function showUserSettings($id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, $id);
    }

    /**
     * @param $id
     * @param array $userSettings
     * @return BaseResponseInterface
     */
    public function updateUserSettings($id, array $userSettings): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, $id, $userSettings);
    }

    /**
     * @param $id
     * @return BaseResponseInterface
     */
    public function deleteUserSettings($id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, $id);
    }

    /**
     * @param array $userSettings
     * @return BaseResponseInterface
     */
    public function storeUpdateBatch(array $userSettings): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $userSettings);
    }

    /**
     * @param int $user_id
     * @return BaseResponseInterface
     */
    public function getUserSenderIds(int $user_id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, compact('user_id'));
    }

    /**
     * @return BaseResponseInterface
     */
    public function getSenderIds(): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__);
    }

    /**
     * @param array $userSettings
     * @return BaseResponseInterface
     */
    public function changeUserSettingsStatus(array $userSettings): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $userSettings);
    }

    /**
     * @param array $messageParams
     * @return BaseResponseInterface
     */
    public function storeMessageStatus(array $messageParams): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $messageParams);
    }
}
