<?php

namespace Intergo\ViberApiClient\Enums;

class ViberMessageStatus
{
    const DELIVERED = 0;
    const SEEN = 1;
    const EXPIRED = 2;

    /**
     * Get all values of all constants
     *
     * @return array
     */
    public static function getConstantValues()
    {
        return array_values((new \ReflectionClass(static::class))->getConstants());
    }

    /**
     * Get constant name
     *
     * @param $value
     * @return int|string
     */
    public static function getConstantName($value)
    {
        return array_flip((new \ReflectionClass(static::class))->getConstants())[$value];
    }
}
