<?php

namespace Intergo\ViberApiClient\ValueObjects;

use App\ValueObject\MessageVO;

class ViberMessageVO
{
    public string $to;
    public ?string $message;

    public int $viber_type;

    public ?string $viber_image_url= null;
    public ?string $viber_target_url= null;
    public ?string $viber_caption = null;
    public ?string $ttl = null;
    public MessageVO $messageVO;

    /**
     * @param array $data
     */
    public function __construct(array $data, $class = null) {
        if (isset($class)) {
            $this->messageVO = new $class($data);
        }
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    /**
     * @return array
     */
    public function toArray(): array {
        return get_object_vars($this);
    }
}
