<?php

namespace Intergo\ViberApiClient\ValueObjects;

class MessageVO
{
    public string $internal_id;
    public ?string $external_id;
    public ?string $campaign_id = null;
    public int $user_id;
    public ?string $sender_id;
    public ?string $status;

    public string $send_from;
    public int $sms_count;
    public ?string $scheduled_for = null;
    public ?string $callback_url;
    public string $created_at;
    public string $sent_at;
    public ?string $timezone;
    public int $product_id = 1;
    public float $client_cost;
    public float $client_cost_in_eur;
    public string $country_code;
    public ?string $currency;
    public ?int $mcc_mnc;
    public int $priority;
    public bool $transcode;
    public ?string $user_queue;
    public ?string $opt_out_code;

    public ?string $failed_reason = null;
    public ?string $internal_failed_reason = null;

    public ?string $direction;
    public ?string $channel;

    /**
     * @param array $data
     */
    public function __construct(array $data) {
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    /**
     * @return array
     */
    public function toArray(): array {
        return get_object_vars($this);
    }
}
