<?php

namespace Intergo\ViberApiClient\ValueObjects;

class ViberMessageVO
{
    public string $internal_id;
    public ?string $external_id;
    public string $callback_url;
    public string $created_at;
    public string $message;
    public bool $is_api;
    public int $sms_count;
    public ?string $scheduled_for;
    public string $sender_id;
    public string $timezone;
    public ?string $to;
    public string $type;
    public int $user_id;
    public ?string $optout;
    public ?string $failed_reason;
    public ?string $internal_failed_reason;
    public string $campaign_id;
    public string $status;
    public int $product_id;
    public float $our_cost;
    public float $client_cost;
    public float $client_cost_in_eur;
    public string $a2_code;
    public int $mcc_mnc;
    public ?string $final_callback_sent;
    public float $received_request_time;
    public int $priority;
    public bool $transcode;
    public ?string $user_queue;

    public ?string $viber_image_url;
    public ?string $viber_target_url;
    public ?string $viber_caption;
    public ?string $viber_provider;
    public ?string $viber_params;
    public ?int $viber_type;

    /**
     * @param array $data
     */
    public function __construct(array $data) {
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    /**
     * @return array
     */
    public function toArray(): array {
        return get_object_vars($this);
    }
}