<?php

namespace Intergo\ViberApiClient;

class ViberTypeParamHelper
{
    public static function rules()
    {
        return
            [
                'viber_type' => ['required', 'in:106,108,109'],
                'ttl' => ['sometimes', 'integer', 'between:30,1209600'],
                'viber_image_url' => [
                    'required_if:viber_type,108',
                    'prohibitedIf:viber_type,106,109',
                    'url'
                ],
                'viber_caption' => [
                    'required_if:viber_type,108,109',
                    'prohibitedIf:viber_type,106',
                    'string'
                ],
                'viber_target_url' => [
                    'required_if:viber_type,108,109',
                    'prohibitedIf:viber_type,106',
                    'url'
                ],
            ];
    }

    /**
     * A unique identifier of a message that links the request and the response.
     *
     * @return int
     */
    public static function generateSequence(): int
    {
        return (int)strtotime('now') . mt_rand(100000000, 999999999);
    }
}