<?php

namespace Intergo\ViberApiClient;

class ViberTypeParamHelper
{
    public static function rules()
    {
        return
            [
                'message' => [
                    'required_if:type,6,106,206,8,108,9,109,208,210,209',
                    'prohibitedIf:type,7,107,207',
                    'string'
                ],
                'viber_type' => ['required', 'in:6,106,7,107,8,108,9,109,206,207,208,210,209'],
                'ttl' => ['sometimes', 'integer', 'between:30,1209600'],
                'viber_image_url' => [
                    'required_if:type,7,107,8,108,207,208,210',
                    'prohibitedIf:type,6,106,206,9,109,209',
                    'url'
                ],
                'viber_caption' => [
                    'required_if:type,8,108,9,109,208,210,209',
                    'prohibitedIf:type,6,106,206,7,107,207',
                    'string'
                ],
                'viber_target_url' => [
                    'required_if:type,8,108,9,109,208,210,209',
                    'prohibitedIf:type,6,106,206,7,107,207',
                    'url'
                ],
            ];
    }

    /**
     * A unique identifier of a message that links the request and the response.
     *
     * @return int
     */
    public static function generateSequence(): int
    {
        return (int)strtotime('now') . mt_rand(100000000, 999999999);
    }
}