<?php

namespace Intergo\ViberApiClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class ViberApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        'sendMessage' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/send/message', self::INTERNAL => true],
        'getUserSettings' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-settings', self::INTERNAL => true],
        'storeUserSettings' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user-settings', self::INTERNAL => true],
        'showUserSettings' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-settings/:id', self::INTERNAL => true],
        'updateUserSettings' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/user-settings/:id', self::INTERNAL => true],
        'deleteUserSettings' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/user-settings/:id', self::INTERNAL => true],
        'storeUpdateBatch' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user-settings/batch', self::INTERNAL => true],
        'getSenderIds' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/sender-ids/user/:user_id', self::INTERNAL => true],
        'changeUserSettingsStatus' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user-settings/status', self::INTERNAL => true],
        'storeMessageStatus' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/store/message/status', self::INTERNAL => true],
    ];
}
