<?php

namespace Intergo\ViberApiClient\Jobs;

use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Intergo\ViberApiClient\ValueObjects\ViberMessageVO;

class BaseSendViberJob implements ShouldQueue
{

    use Batchable, InteractsWithQueue, Queueable, SerializesModels;
    protected string $trace_id;
    public int $priority = 3;
    protected ViberMessageVO $message;

    /**
     * Constructor to assign data
     *
     * @param ViberMessageVO $message
     * @param int $priority
     * @param string $traceId
     */
    public function __construct(ViberMessageVO $message, int $priority, string $traceId)
    {
        $this->trace_id = $traceId;
        $this->message = $message;
        $this->priority = $priority;
    }

    /**
     * @return void
     */
    public function handle()
    {
        //
    }

}
