<?php

namespace Intergo\VerifyClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class VerifierServiceManager
{
    /** @var VerifierClient */
    protected $client;


    /** @var string */
    protected $token;

    public function __construct(string $baseUrl, string $traceId, string $token = null)
    {
        $this->client = new VerifierClient($baseUrl, $traceId);
        $this->token = $token;
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    /**
     * @param $endpoint
     * @param  array  $urlParams
     * @param  array  $bodyParams
     * @return BaseResponseInterface
     */
    protected function executeAuth($endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        $result = $this->client->executeAuth($endpoint, $this->token, $urlParams, $bodyParams);
        return $this->response($endpoint, $result);
    }

    /***********************Applications****************************/
    public function getApplication($id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'));
    }
    public function getApplications(): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__);
    }
    public function storeApplication($name, $user_id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, [],compact('name', 'user_id'));
    }
    public function updateApplication($id, $name, $user_id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'),compact('name', 'user_id'));
    }
    public function deleteApplication($id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'));
    }
    /***********************Applications Settings****************************/
    public function getApplicationSetting($id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'));
    }
    public function storeApplicationSetting($channel, $min_length, $max_length, $max_tries, $ttl, $password_type, $callback_url, $application_id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, [], compact(
            'channel',
            'min_length',
            'max_length',
            'max_tries',
            'ttl',
            'password_type',
            'callback_url',
            'application_id'));
    }
    public function updateApplicationSetting($id, $channel, $min_length, $max_length, $max_tries, $ttl, $password_type, $callback_url, $application_id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'),compact(
            'channel',
            'min_length',
            'max_length',
            'max_tries',
            'ttl',
            'password_type',
            'callback_url',
            'application_id'));
    }
    public function deleteApplicationSetting($id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'));
    }
    /***********************Billing Settings****************************/
    public function getBillingSetting($id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'));
    }
    public function storeBillingSetting($channel, $our_cost, $cost_success, $cost_fail, $application_id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, [], compact(
            'channel',
            'our_cost',
            'cost_success',
            'cost_fail',
            'application_id'));
    }
    public function storeLocalizeBillingSettings($channel, $application_id, $billing): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, [], compact(
            'channel',
            'application_id',
            'billing'));
    }
    public function updateBillingSetting($id, $channel, $our_cost, $cost_success, $cost_fail, $application_id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'),compact(
            'channel',
            'our_cost',
            'cost_success',
            'cost_fail',
            'application_id'));
    }
    public function deleteBillingSetting($id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'));
    }
    /***********************Templates****************************/
    public function getTemplate($id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'));
    }
    public function storeTemplate($locale, $channel, $title, $message, $application_id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, [],compact('locale',
            'channel',
            'title',
            'message',
            'application_id'));
    }
    public function storeLocalizeTemplates($channel, $application_id, $templates): BaseResponseInterface
    {
        return $this->executeAuth(
            __FUNCTION__,
            [],
            compact(
            'channel',
            'application_id',
            'templates')
        );
    }
    public function updateTemplate($id, $locale, $channel, $title, $message, $application_id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'),compact('locale',
            'channel',
            'title',
            'message',
            'application_id'));
    }
    public function deleteTemplate($id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'));
    }
    /***********************Templates****************************/
    public function create($guid, $recipient, $reference, $callback_url, $channel): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, [], compact(
            'guid',
            'recipient',
            'reference',
            'callback_url',
            'channel',
        ));
    }
    public function confirm($id, $password): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, [], compact('id', 'password'));
    }
    public function cancel($id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, [], compact('id'));
    }
    public function status($id): BaseResponseInterface
    {
        return $this->executeAuth(__FUNCTION__, compact('id'));
    }
    public function list($queryString): BaseResponseInterface
    {
        if (is_string($queryString)) {
            parse_str($queryString, $queryString);
        }
        extract($queryString);
        unset($queryString);
        return $this->executeAuth(__FUNCTION__, [], get_defined_vars());
    }
}