<?php

namespace Intergo\VerifyClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class VerifierApiHandler extends ApiHandler
{
    protected static $endpoints = [
        ############################################### APPLICATIONS ###############################################
        'getApplication' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/applications/:id', self::INTERNAL => true],
        'getApplications' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/applications', self::INTERNAL => true],
        'storeApplication' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/applications', self::INTERNAL => true],
        'updateApplication' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/applications/:id', self::INTERNAL => true],
        'deleteApplication' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/applications/:id', self::INTERNAL => true],
        ########################################### APPLICATION SETTINGS ###########################################
        'getApplicationSetting' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/application-settings/:id', self::INTERNAL => true],
        'storeApplicationSetting' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/application-settings', self::INTERNAL => true],
        'updateApplicationSetting' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/application-settings/:id', self::INTERNAL => true],
        'deleteApplicationSetting' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/application-settings/:id', self::INTERNAL => true],
        ############################################# BILLING SETTINGS #############################################
        'getBillingSetting' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/billing-settings', self::INTERNAL => true],
        'storeBillingSetting' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/billing-settings', self::INTERNAL => true],
        'storeLocalizeBillingSettings' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/billing-settings/store-localized', self::INTERNAL => true],
        'updateBillingSetting' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/billing-settings/:id', self::INTERNAL => true],
        'deleteBillingSetting' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/billing-settings/:id', self::INTERNAL => true],
        ################################################ TEMPLATES #################################################
        'getTemplate' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/templates/:id', self::INTERNAL => true],
        'storeTemplate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/templates', self::INTERNAL => true],
        'storeLocalizeTemplates' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/templates/store-localized', self::INTERNAL => true],
        'updateTemplate' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/templates/:id', self::INTERNAL => true],
        'deleteTemplate' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/templates/:id', self::INTERNAL => true],
        ############################################## VERIFICATIONS ###############################################
        'create' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/verifications/create'],
        'confirm' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/verifications/confirm'],
        'cancel' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/verifications/cancel'],
        'status' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/verifications/status/:id'],
        'list' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/verifications/list'],
    ];

}