<?php

namespace Intergo\VerifyClient\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class BaseSendVerifyJob implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected string $trace_id;
    protected array $messages;
    protected string $channel;

    /**
     * Constructor to assign data
     *
     * @param array $messages
     * @param string $traceId
     */
    public function __construct(array $messages, string $channel, string $traceId)
    {
        $this->messages = $messages;
        $this->channel = $channel;
        $this->trace_id = $traceId;
    }

    /**
     * @return void
     */
    public function handle()
    {
        //
    }
}