<?php

namespace Intergo\VerifyClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class VerifierApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        ############################################### APPLICATIONS ###############################################
        'getApplication' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/applications/:id', self::INTERNAL => true],
        'getApplications' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/applications', self::INTERNAL => true],
        'getMyApplications' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/applications/me/:userId', self::INTERNAL => true],
        'storeApplication' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/applications', self::INTERNAL => true],
        'deleteApplication' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/applications/:id', self::INTERNAL => true],
        ########################################### APPLICATION SETTINGS ###########################################
        'storeApplicationSetting' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/application-settings', self::INTERNAL => true],
        ############################################# BILLING SETTINGS #############################################
        'storeBillingSetting' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/billing-settings', self::INTERNAL => true],
        'storeLocalizeBillingSettings' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/billing-settings/store-localized', self::INTERNAL => true],
        ################################################ TEMPLATES #################################################
        'storeTemplate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/templates', self::INTERNAL => true],
        'storeLocalizeTemplates' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/templates/store-localized', self::INTERNAL => true],
        ############################################## VERIFICATIONS ###############################################
        'getRecipient' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/verifications/recipient', self::INTERNAL => true],
        'createSystem' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/verifications/system/create', self::INTERNAL => true],
        'confirmSystem' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/verifications/system/confirm', self::INTERNAL => true],
        'getGuid' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/verifications/system/guid/:recipient', self::INTERNAL => true],
        'listInternal' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/verifications/list', self::INTERNAL => true],
        'listUserInternal' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/verifications/user/list/:userId', self::INTERNAL => true],
        'statisticsInternal' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/verifications/statistics/:userId', self::INTERNAL => true],
        'export' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/verifications/export/:userId', self::INTERNAL => true],
        'managerExport' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/verifications/export/manager/:userId', self::INTERNAL => true],
        ############################################## FAILED JOBS ###############################################
        'getFailedJobs' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/failed-jobs', self::INTERNAL => false],
        'getFailedJob' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/failed-jobs/:id', self::INTERNAL => true],
        'getFailedJobsQueues' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/failed-jobs/queues', self::INTERNAL => true],
        'retryFailedJobs' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/failed-jobs/retry', self::INTERNAL => true],
        'deleteFailedJobs' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/failed-jobs/delete', self::INTERNAL => true],

    ];
}
