<?php

namespace Intergo\VerifyClient\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class BaseSendVerifyJob implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected string $trace_id;
    protected array $smsOtpMessages;

    /**
     * Constructor to assign data
     *
     * @param array $smsOtpMessages
     * @param string $traceId
     */
    public function __construct(array $smsOtpMessages, string $traceId)
    {
        $this->smsOtpMessages = $smsOtpMessages;
        $this->trace_id = $traceId;
    }

    /**
     * @return void
     */
    public function handle()
    {
        //
    }
}