<?php

namespace Intergo\TextToVoiceApiClient;


use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class TextToVoiceApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        'getUserCountrySettingList' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-country-setting', self::INTERNAL => true],
        'getUserCountrySetting' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-country-setting/:id', self::INTERNAL => true],
        'addUserCountrySetting' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user-country-setting/:userSettingsId', self::INTERNAL => true],
        'updateUserCountrySetting' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/user-country-setting/:id', self::INTERNAL => true],
        'deleteUserCountrySetting' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/user-country-setting/:id', self::INTERNAL => true],
        'getUserSettings' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-settings', self::INTERNAL => true],
        'enableUserSettings' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user-settings', self::INTERNAL => true],
        'updateUserSettings' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/user-settings/:id', self::INTERNAL => true],
        'deleteUserSettings' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/user-settings/:id', self::INTERNAL => true],
    ];


}