<?php

namespace Intergo\TextToVoiceApiClient;


use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class TextToVoiceApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        'getUserSettings' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-settings', self::INTERNAL => true],
        'enableUserSettings' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user-settings', self::INTERNAL => true],
        'updateUserSettings' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/user-settings/:id', self::INTERNAL => true],
        'processVoiceOtpResponse' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/provider-callback/voice-otp', self::INTERNAL => true],
    ];


}