<?php

namespace Intergo\TextToVoiceApiClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractTextToVoiceApiService
{

    private TextToVoiceApiClient $client;

    public function __construct(string $baseUrl, string $traceId)
    {
        $this->client = new TextToVoiceApiClient($baseUrl, $traceId);
    }

    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    /**
     * @param int $user_id
     * @return BaseResponseInterface
     */
    public function getUserSettings(int $user_id): BaseResponseInterface
    {
        $urlParams = [
            'user_id' => $user_id,
        ];
        return $this->execute(__FUNCTION__, [], $urlParams);

    }

    /**
     * @param int $user_id
     * @param bool $is_enabled
     * @param string $default_provider
     * @param string $default_language
     * @param int $loop_count
     * @return BaseResponseInterface
     */
    public function enableUserSettings(int $user_id, bool $is_enabled, string $default_provider, string $default_language, int $loop_count): BaseResponseInterface
    {
        $bodyParams = [
            'user_id' => $user_id,
            'is_enabled' => $is_enabled,
            'default_provider' => $default_provider,
            'default_language' => $default_language,
            'loop_count' => $loop_count,
        ];
        return $this->execute(__FUNCTION__, $bodyParams, []);

    }


    /**
     * @param int $id
     * @return BaseResponseInterface
     */
    public function deleteUserSettings(int $id): BaseResponseInterface
    {
        $urlParams = [
            'id' => $id,
        ];
        return $this->execute(__FUNCTION__, [], $urlParams);
    }

    /**
     * @param array $messageParams
     * @return BaseResponseInterface
     */
    public function processVoiceOtpResponse(array $messageParams): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $messageParams);
    }

    /**
     * @param int $user_id
     * @return BaseResponseInterface
     */
    public function getUserCountrySettingList(int $user_id): BaseResponseInterface
    {
        $urlParams = [
            'user_id' => $user_id,
        ];
        return $this->execute(__FUNCTION__, [], $urlParams);
    }

    /**
     * @param int $id
     * @return BaseResponseInterface
     */
    public function getUserCountrySetting(int $id): BaseResponseInterface
    {
        $urlParams = [
            'id' => $id,
        ];
        return $this->execute(__FUNCTION__, [], $urlParams);
    }

    /**
     * @param string $userSettingsId
     * @param string $mcc
     * @param string $provider
     * @param string $language
     * @param int $loop_count
     * @return BaseResponseInterface
     */
    public function addUserCountrySetting(string $userSettingsId, string $mcc, string $provider, string $language, int $loop_count): BaseResponseInterface
    {
        $urlParams = [
            'user_settings_id' => $userSettingsId
        ];
        $bodyParams = [
            'mcc' => $mcc,
            'provider' => $provider,
            'language' => $language,
            'loop_count' => $loop_count,
        ];
        return $this->execute(__FUNCTION__, $bodyParams, $urlParams);
    }

    /**
     * @param int $id
     * @param string $mcc
     * @param string $provider
     * @param string $language
     * @param int $loop_count
     * @return BaseResponseInterface
     */
    public function updateUserCountrySetting(int $id, string $mcc, string $provider, string $language, int $loop_count): BaseResponseInterface
    {
        $urlParams = [
            'id' => $id
        ];
        $bodyParams = [
            'mcc' => $mcc,
            'provider' => $provider,
            'language' => $language,
            'loop_count' => $loop_count,
        ];
        return $this->execute(__FUNCTION__, $urlParams, $bodyParams);
    }

    /**
     * @param int $id
     * @return BaseResponseInterface
     */
    public function deleteUserCountrySetting(int $id): BaseResponseInterface
    {
        $urlParams = [
            'id' => $id,
        ];
        return $this->execute(__FUNCTION__, [], $urlParams);    
    }
}
