<?php

namespace Intergo\TelegramApiClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractTelegramApiService
{

    private TelegramApiClient $client;

    public function __construct(string $baseUrl, string $traceId)
    {
        $this->client = new TelegramApiClient($baseUrl, $traceId);
    }

    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    /**
     * @param int $user_id
     * @return BaseResponseInterface
     */
    public function getUserSettings(int $user_id): BaseResponseInterface
    {
        $urlParams = [
            'user_id' => $user_id,
        ];
        return $this->execute(__FUNCTION__, [], $urlParams);

    }

    /**
     * @param $user_id
     * @param $is_enabled
     * @return BaseResponseInterface
     */
    public function enableUserSettings($user_id, $is_enabled): BaseResponseInterface
    {

        return $this->execute(__FUNCTION__, [], compact('user_id', 'is_enabled'));

    }


    /**
     * @param $id
     * @param $user_id
     * @param $is_enabled
     * @return BaseResponseInterface
     */
    public function updateUserSettings($id, $user_id, $is_enabled): BaseResponseInterface
    {

        return $this->execute(__FUNCTION__, compact('id'), compact('user_id', 'is_enabled'));
    }

    /**
     * @param array $messageParams
     * @return BaseResponseInterface
     */
    public function processAlarisResponse(array $messageParams): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $messageParams);
    }

}
