<?php

namespace Intergo\SubscriptionClient\Enums;

class SubscriptionStatusEnum
{
    const ACTIVE = "Active";
    const CANCELLED = "Cancelled";
    const GRACE_PERIOD = "On Grace";
    const FREEZE_PERIOD = "On Freeze";
    const CANCEL_REQUESTED = "Cancel in progress";

    /**
     * @param $status
     * @return bool
     */
    public static function canBeRenewed($status)
    {
        return in_array($status, [
           self::GRACE_PERIOD,
           self::FREEZE_PERIOD,
        ]);
    }

    /**
     * @param $status
     * @return bool
     */
    public static function canBeCancelled($status)
    {
        return in_array($status, [
           self::ACTIVE,
           self::GRACE_PERIOD,
           self::FREEZE_PERIOD,
        ]);
    }
}
