<?php

namespace Intergo\SubscriptionClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class SubscriptionApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        //Plans
        'getPlans' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/plans', self::INTERNAL => true],
        'getPlanById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/plans/:id', self::INTERNAL => true],
        'createPlan' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/plans', self::INTERNAL => true],
        'updatePlan' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/plans/:id', self::INTERNAL => true],
        'deletePlan' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/plans/:id', self::INTERNAL => true],
        'getPlansByIds' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/plans/ids', self::INTERNAL => true],
        'getPlanCountries' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/plans/countries', self::INTERNAL => true],
        'getRentingPlansByParams' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/plans/renting', self::INTERNAL => true],

        //Subscriptions
        'getSubscriptions' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/subscriptions', self::INTERNAL => true],
        'getSubscriptionById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/subscriptions/:id', self::INTERNAL => true],
        'storeSubscription' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/subscriptions', self::INTERNAL => true],
        'cancelSubscription' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/subscriptions/:id/cancel', self::INTERNAL => true],
        'revertCancelSubscription' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/subscriptions/:id/cancel/revert', self::INTERNAL => true],
        'checkIfCancelled' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/subscriptions/check/cancelled', self::INTERNAL => true],
        'renewSubscription' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/subscriptions/:id/renew', self::INTERNAL => true],
        'getUserSubscriptions' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/subscriptions/user/:id', self::INTERNAL => true],
        'getUserSubscriptionsReport' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/subscriptions/user/:id/report', self::INTERNAL => true],
        'getSubscriptionsByIds' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/subscriptions/ids', self::INTERNAL => true],


        //Subscription Billing Logs
        'getSubscriptionBillingLogs' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/subscriptions/:id/logs', self::INTERNAL => true],
        'getSubscriptionBillingLog' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/subscriptions/:id/logs/:log_id', self::INTERNAL => true],
        'storeSubscriptionBillingLog' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/subscriptions/:id/logs', self::INTERNAL => true],
    ];
}
