<?php

namespace Intergo\SubscriptionClient\Enums;

class SubscriptionStatusEnum
{
    const ACTIVE = "Active";
    const CANCELLED = "Cancelled";
    const GRACE_PERIOD = "On Grace";
    const CANCEL_REQUESTED = "Cancel in progress";


    /**
     * @param $status
     * @return bool
     */
    public static function canBeRenewed($status)
    {
        return $status == self::GRACE_PERIOD;
    }

    /**
     * @param $status
     * @return bool
     */
    public static function canBeCancelled($status)
    {
        return $status == self::ACTIVE;
    }

    /**
     * @param $status
     * @return bool
     */
    public static function canBeCancelReverted($status)
    {
        return $status == self::CANCEL_REQUESTED;
    }
}
