<?php

namespace Intergo\Shortlinks\Enums;

class ShortlinksEnum
{
    const CACHE_CONNECTION = 'app';
    const EXPIRATION = 60;
    const EX = 'ex';

    const APP_DB_CONNECTION = 'smsto_mysql';
    const SHORTLINKS_TABLE = 'shortlinks';
    const USERS_TABLE = 'users';
    const CONTACT_PLACEHOLDERS = ['{FIRSTNAME}', '{LASTNAME}', '{EMAIL}', '{PHONE}', '{CUSTOM1}', '{CUSTOM2}'];

    /**
     * @param $id
     * @return string
     */
    public static function cacheKey($id) {
        return "User:$id:shortlinks";
    }
}
