<?php

namespace Intergo\Shortlinks;

use Intergo\Shortlinks\Enums\ShortlinksEnum;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redis;

class ShortlinksRepository
{
    private DB $db;
    private string $connection;
    private Redis $redis;

    public function __construct(DB $db, $redis, $connection)
    {
        $this->db = $db;
        $this->connection = $connection;
        $this->redis = $redis;
    }

    /**
     * @param $authUserId
     * @return array
     */
    public function getUserShortlinks($authUserId)
    {
        $userShortlinks = $this->redis::connection(ShortlinksEnum::CACHE_CONNECTION)->get(ShortlinksEnum::cacheKey($authUserId));
        if (empty($userShortlinks)) {
            $userShortlinks = $this->db::connection($this->connection)->table(ShortlinksEnum::SHORTLINKS_TABLE)
                ->join(
                    ShortlinksEnum::USERS_TABLE,
                    ShortlinksEnum::USERS_TABLE . '.id',
                    '=',
                    ShortlinksEnum::SHORTLINKS_TABLE . '.user_id'
                )
                ->where(ShortlinksEnum::USERS_TABLE . '._id', '=', $authUserId)
                ->get([ShortlinksEnum::SHORTLINKS_TABLE . '.*']);

            $userShortlinks = $userShortlinks->toJson();
            $this->redis::connection(ShortlinksEnum::CACHE_CONNECTION)->set(
                ShortlinksEnum::cacheKey($authUserId),
                $userShortlinks,
                ShortlinksEnum::EX,
                ShortlinksEnum::EXPIRATION
            );
        }
        return json_decode($userShortlinks, true);
    }

    /**
     * @param $shortlinkId
     * @param $attributes
     * @return void
     */
    public function updateShortlink($shortlinkId, $attributes)
    {
        $this->db::connection($this->connection)->table(ShortlinksEnum::SHORTLINKS_TABLE)
            ->where('id', $shortlinkId)
            ->update($attributes);
    }
}
