<?php

namespace Intergo\ShortlinkClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class ShortlinkApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        #SHORTLINKS
        'createShortlink' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/shortlinks', self::INTERNAL => true],
        'deleteShortlink' => [
            self::METHOD => HttpMethodEnum::DELETE,
            self::URL => '/shortlinks/:id  ',
            self::INTERNAL => true
        ],
        'restoreShortlink' => [
            self::METHOD => HttpMethodEnum::POST,
            self::URL => '/shortlinks/restore/:id',
            self::INTERNAL => true
        ],
        'getShortlinksByUser' => [
            self::METHOD => HttpMethodEnum::GET,
            self::URL => '/shortlinks/users/:userId',
            self::INTERNAL => true
        ],
        'getShortlinkDetails' => [
            self::METHOD => HttpMethodEnum::GET,
            self::URL => '/shortlinks/:id',
            self::INTERNAL => true
        ],
        'updateMessageCount' => [
            self::METHOD => HttpMethodEnum::PATCH,
            self::URL => '/shortlinks/message-count',
            self::INTERNAL => true
        ],
    ];
}