<?php

namespace Intergo\ShortlinkClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractShortlinkService
{
    protected ShortlinkClient $client;

    /**
     * AbstractSubscriptionService constructor.
     * https://intergo.atlassian.net/wiki/spaces/ES/pages/2149187587/Communication+between+microservices
     *
     * @param $baseUrl
     * @param $traceId
     */
    public function __construct($baseUrl, $traceId)
    {
        $this->client = new ShortlinkClient($baseUrl, $traceId);
    }


    /**
     * @param $attributes
     * @return  BaseResponseInterface
     */
    public function createShortlink($attributes)
    {
        extract($attributes);
        unset($attributes);
        return $this->execute(__FUNCTION__, get_defined_vars());
    }

    /**
     * @param $id
     * @return BaseResponseInterface
     */
    public function deleteShortlink($attributes, $id)
    {
        return $this->execute(__FUNCTION__, $attributes, compact('id'));
    }

    /**
     * @param $id
     * @return BaseResponseInterface
     */
    public function restoreShortlink($attributes, $id)
    {
        return $this->execute(__FUNCTION__, $attributes, compact('id'));
    }

    /**
     * @param $id
     * @return BaseResponseInterface
     */
    public function getShortlinksByUser($attributes,$userId)
    {
        return $this->execute(__FUNCTION__, $attributes, compact('userId'));
    }

    /**
     * Retrieves the details(clicks) of specific shortlink
     * @param $attributes
     * @param $id
     * @return void
     */
    public function getShortlinkDetails($attributes, $id) {
        return $this->execute(__FUNCTION__, $attributes, compact('id'));
    }


    /**
     * Updates the message count of detected shortlinks of user if exist's in the message
     * @param $attributes
     * @param $id
     * @return void
     */
    public function updateMessageCount($attributes, $id) {
        return $this->execute(__FUNCTION__, $attributes);
    }


    /**
     * @param $endpoint
     * @param $bodyParams
     * @param array $urlParams
     * @return BaseResponseInterface
     */
    protected function execute($endpoint, $bodyParams, array $urlParams = [])
    {
        $result = $this->client->execute($endpoint, $urlParams, $bodyParams);
        return $this->response($endpoint, $result);
    }

    abstract public function response(string $action, BaseResponseInterface $result);


}