<?php

namespace Intergo\ShortlinkClient\ValueObjects;

class TrackClickVO
{
    private string $ip;
    private string $device;
    private string $os;
    private string $browser;
    private ?string $language;

    public function __construct(string $ip, string $device, string $os, string $browser, ?string $language = null)
    {
        $this->ip = $ip;
        $this->device = $device;
        $this->os = $os;
        $this->browser = $browser;
        $this->language = $language;
    }

    public function toArray(): array
    {
        return [
            'ip' => $this->ip,
            'device' => $this->device,
            'os' => $this->os,
            'browser' => $this->browser,
            'language' => $this->language,
        ];
    }
}
