<?php

namespace Intergo\ShortlinkClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class ShortlinkApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        #SHORTLINKS
        'createShortlink' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/shortlinks', self::INTERNAL => true],
        'deleteShortlink' => [
            self::METHOD => HttpMethodEnum::DELETE,
            self::URL => '/shortlinks/:id  ',
            self::INTERNAL => true
        ],
        'restoreShortlink' => [
            self::METHOD => HttpMethodEnum::POST,
            self::URL => '/shortlinks/restore/:id',
            self::INTERNAL => true
        ],
        'getShortlinksByUser' => [
            self::METHOD => HttpMethodEnum::GET,
            self::URL => '/users/:userId',
            self::INTERNAL => true
        ],
        'getAllShortlinksByUser' => [
            self::METHOD => HttpMethodEnum::GET,
            self::URL => '/users/:userId/all',
            self::INTERNAL => true
        ],
        'getShortlinkDetails' => [
            self::METHOD => HttpMethodEnum::GET,
            self::URL => '/shortlinks/:id',
            self::INTERNAL => true
        ],
        'getAllShortlinkDetails' => [
            self::METHOD => HttpMethodEnum::GET,
            self::URL => '/shortlinks/:id/all',
            self::INTERNAL => true
        ],
        'updateMessageCount' => [
            self::METHOD => HttpMethodEnum::PATCH,
            self::URL => '/shortlinks/message-count',
            self::INTERNAL => true
        ],
        'replaceUnique' => [
            self::METHOD => HttpMethodEnum::POST,
            self::URL => '/shortlinks/prepare-uniques',
            self::INTERNAL => true
        ],
        'getAllShortlinks' => [
            self::METHOD => HttpMethodEnum::GET,
            self::URL => '/manager/shortlinks/all',
            self::INTERNAL => true
        ],
        'updateShortlinkStatus' => [
            self::METHOD => HttpMethodEnum::PATCH,
            self::URL => '/manager/shortlinks/:id/status',
            self::INTERNAL => true,
        ],
        'bulkUpdateStatus' => [
            self::METHOD => HttpMethodEnum::POST,
            self::URL => '/manager/shortlinks/status',
            self::INTERNAL => true
        ],
        'updateUserDomain' => [
            self::METHOD => HttpMethodEnum::PUT,
            self::URL => '/users/:userId/domains',
            self::INTERNAL => true
        ],
        'getUserDomain' => [
            self::METHOD => HttpMethodEnum::GET,
            self::URL => '/users/:userId/domains',
            self::INTERNAL => true
        ],
        'updateCustomDomain' => [
            self::METHOD => HttpMethodEnum::PUT,
            self::URL => '/domains/custom',
            self::INTERNAL => true
        ],
        'getCustomDomains' => [
            self::METHOD => HttpMethodEnum::GET,
            self::URL => '/domains/custom',
            self::INTERNAL => true
        ],
        'trackShortlinkClick' => [
            self::METHOD => HttpMethodEnum::POST,
            self::URL => '/shortlinks/clicks/:code',
            self::INTERNAL => true
        ]
    ];
}