<?php

namespace Intergo\ShortlinkService;
use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractShortlinkService
{

    /**
     * AbstractSubscriptionService constructor.
     * https://intergo.atlassian.net/wiki/spaces/ES/pages/2149187587/Communication+between+microservices
     *
     * @param $baseUrl
     * @param $traceId
     */
    public function __construct($baseUrl, $traceId)
    {
        $this->client = new ShortlinkClient($baseUrl, $traceId);
    }


    /**
     * @param $attributes
     * @return  BaseResponseInterface
     */
    public function createShortlink($attributes)
    {
        extract($attributes);
        unset($attributes);
        return $this->execute(__FUNCTION__, get_defined_vars());
    }


}