<?php

namespace Intergo\ServiceViberClient\Jobs;

use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Queue;
use Intergo\ServiceViberClient\ValueObjects\ViberMessageStatusVO;
class BaseStoreViberMessageStatusJob implements ShouldQueue
{
    use Batchable, InteractsWithQueue, Queueable, SerializesModels;
    protected string $trace_id;
    public int $priority = 3;
    protected ViberMessageStatusVO $message;

    /**
     * Constructor to assign data
     *
     * @param ViberMessageStatusVO $message
     * @param int $priority
     * @param string $traceId
     */
    public function __construct(ViberMessageStatusVO $message, int $priority, string $traceId)
    {
        $this->trace_id = $traceId;
        $this->message = $message;
        $this->priority = $priority;
    }

    /**
     * @return void
     */
    public function handle()
    {
        //
    }

    public function send(string $queueName)
    {
        Queue::pushRaw(json_encode($this->message), $queueName);
    }
}