<?php

namespace Intergo\ServiceViberClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractServiceViberClient
{
    protected ServiceViberClient $client;

    public function __construct($baseUrl, $traceId)
    {
        $this->client = new ServiceViberClient($baseUrl, $traceId);
    }

    /**
     * @param string $endpoint
     * @param array $urlParams
     * @param array $bodyParams
     * @return BaseResponseInterface
     */
    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    public function listViberMessages(
        ?string $senderId = null,
        ?string $to = null,
        ?int $userId = null,
        ?int $viberType = null,
        ?int $page = null,
        ?int $pageSize = null,
        ?string $orderBy = null,
        ?string $direction = null
    ) : BaseResponseInterface {
        $urlParams = [
            'sender_id' => $senderId,
            'to' => $to,
            'user_id' => $userId,
            'viber_type' => $viberType,
            'page' => $page,
            'page_size' => $pageSize,
            'order_by' => $orderBy,
            'direction' => $direction,
        ];

        return $this->execute(__FUNCTION__,[], $urlParams );
    }
}