<?php

namespace Intergo\ServiceViberClient\ValueObjects;

use Intergo\CommonSending\DataTransferObjects\MessageDTO;

class ViberMessageStatusVO
{
    public string $internal_id;
    public string $status;
    public string $received_at;
    public ?bool $is_free = false;

    public function __construct(array $data)
    {
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return get_object_vars($this);
    }

}
