<?php

namespace Intergo\ServiceViberClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractServiceViberClient
{
    protected ServiceViberClient $client;

    public function __construct($baseUrl, $traceId)
    {
        $this->client = new ServiceViberClient($baseUrl, $traceId);
    }

    /**
     * @param string $endpoint
     * @param array $urlParams
     * @param array $bodyParams
     * @return BaseResponseInterface
     */
    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    public function listViberMessages(
        ?string $senderId = null,
        ?string $to = null,
        ?int $userId = null,
        ?int $viberType = null,
        ?string $internalId = null,
        ?string $externalId = null,
        ?string $status = null,
        ?string $createdAtFrom = null,
        ?string $createdAtTo = null,
        ?string $trackingData = null,
        ?int $page = null,
        ?int $pageSize = null,
        ?string $orderBy = null,
        ?string $direction = null,
        ?string $optOutCodes =null
    ) : BaseResponseInterface {
        $urlParams = [
            'sender_id' => $senderId,
            'to' => $to,
            'user_id' => $userId,
            'viber_type' => $viberType,
            'internal_id' => $internalId,
            'external_id' => $externalId,
            'status' => $status,
            'created_at_from' => $createdAtFrom,
            'created_at_to' => $createdAtTo,
            'tracking_data' => $trackingData,
            'page' => $page,
            'page_size' => $pageSize,
            'order_by' => $orderBy,
            'direction' => $direction,
            'opt_out_codes' => $optOutCodes,
        ];

        return $this->execute(__FUNCTION__, [], $urlParams);
    }

    public function storeFallbackInfo($internal_id, $fallback_id, $fallback_channel): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, compact('internal_id'), compact('fallback_id', 'fallback_channel'));
    }
}