<?php

namespace Intergo\ServiceViberClient\ValueObjects;

class ViberMessageVO
{
    public $to;
    public ?string $message;

    public int $viber_type;

    public ?string $viber_image_url= null;
    public ?string $viber_target_url= null;
    public ?string $viber_caption = null;
    public ?string $ttl = null;
    public ?MessageVO $messageVO;

    /**
     * @param array $data
     */
    public function __construct(array $data) {
        $this->messageVO = new MessageVO($data);
        foreach ($data as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    /**
     * @return array
     */
    public function toArray(): array {
        return get_object_vars($this);
    }
}
