<?php

namespace Intergo\ServiceTextToVoiceClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractServiceTextToVoiceClient
{
    protected ServiceTextToVoiceClient $client;
    protected $baseUrl;

    public function __construct($baseUrl, $traceId)
    {
        $this->baseUrl = $baseUrl;
        $this->client = new ServiceTextToVoiceClient($baseUrl, $traceId);
    }

    /**
     * @param string $endpoint
     * @param array $urlParams
     * @param array $bodyParams
     * @return BaseResponseInterface
     */
    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    public function listVoiceOtpMessages(
        ?string $senderId = null,
        ?string $to = null,
        ?int $userId = null,
        ?string $internalId = null,
        ?string $externalId = null,
        ?string $status = null,
        ?string $createdAtFrom = null,
        ?string $createdAtTo = null,
        ?int $page = null,
        ?int $pageSize = null,
        ?string $orderBy = null,
        ?string $direction = null,
        ?string $optOutCodes =null,
        ?int $isOtp=null
    ) : BaseResponseInterface {
        $urlParams = [
            'sender_id' => $senderId,
            'to' => $to,
            'user_id' => $userId,
            'internal_id' => $internalId,
            'external_id' => $externalId,
            'status' => $status,
            'created_at_from' => $createdAtFrom,
            'created_at_to' => $createdAtTo,
            'page' => $page,
            'page_size' => $pageSize,
            'order_by' => $orderBy,
            'direction' => $direction,
            'opt_out_codes' => $optOutCodes,
            'is_otp' => $isOtp,
        ];

        return $this->execute(__FUNCTION__, [], $urlParams);
    }

    public function exportVoiceOtpMessages(
        $bearerToken,
        $user_id,
        $sender_id,
        $to,
        $created_at_from,
        $created_at_to,
        $status,
        $internal_id,
        $external_id,
        $is_manager,
        $page,
        $page_size,
        $order_by,
        $direction
    ): BaseResponseInterface {

        return $this->client->executeCustom(
            $this->baseUrl ."/api/internal/v1/voice-otp-messages/export",
            'POST',
            [],
            compact('user_id', 'sender_id', 'to', 'created_at_from', 'created_at_to', 'status',
                'internal_id', 'external_id', 'page', 'page_size', 'order_by', 'direction', 'is_manager'),
            $bearerToken);
    }

    /**
     * @param $user_id
     * @return BaseResponseInterface
     */
    public function statisticsOfVoiceOtpMessages($user_id)
    {
        return $this->execute(__FUNCTION__, [], compact('user_id'));
    }


}
