<?php

namespace Intergo\ServiceKycClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class ServiceKycApiHandler extends ApiHandler
{
protected static array $endpoints = [
    // Rules
    'getAllRules' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/rules', self::INTERNAL => true],
    'getRuleById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/rules/:ruleId', self::INTERNAL => true],
    'createRule' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/rules', self::INTERNAL => true],
    'updateRule' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/rules/:ruleId', self::INTERNAL => true],
    'deleteRule' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/rules/:ruleId', self::INTERNAL => true],

    // Decision Logic
    'getDecisionLogic' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/decision-logic', self::INTERNAL => true],
    'updateDecisionLogic' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/decision-logic/:id', self::INTERNAL => true],

    // Requests / Qualifications
    'getAllRequests' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/request/all', self::INTERNAL => true],
    'getRequestById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/request/result/:requestId', self::INTERNAL => true],
];

}
