<?php

namespace Intergo\ServiceKycClient\DataTransferObjects;

class RuleDTO
{
    /** @var string|null */
    public ?string $id = null;

    /** @var string|null */
    public ?string $type = null;

    /** @var string|null */
    public ?string $name = null;

    /** @var string|null */
    public ?string $description = null;

    /** @var int|null */
    public ?int $positiveScore = null;

    /** @var int|null */
    public ?int $negativeScore = null;

    /** @var bool|null */
    public ?bool $status = null;

    /**
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->id = isset($data["id"]) ? $data["id"] : null;
        $this->type = isset($data["type"]) ? $data["type"] : null;
        $this->name = isset($data["name"]) ? $data["name"] : null;
        $this->description = isset($data["description"]) ? $data["description"] : null;
        $this->positiveScore = isset($data["positiveScore"]) ? $data["positiveScore"] : 0;
        $this->negativeScore = isset($data["negativeScore"]) ? $data["negativeScore"] : 0;
        if (isset($data["status"])) {
            $this->status = ($data["status"] === "on" || $data["status"] === true) ? true : false;
        } else {
            $this->status = false;
        }
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return get_object_vars($this);
    }
}
