<?php

namespace Intergo\ServiceKycClient\DataTransferObjects;

class ScoreItemDTO
{
    /** @var string|null */
    public ?string $name = null;

    /** @var float|null */
    public ?float $score = null;

    /** @var string|null */
    public ?string $reason = null;

    public function __construct(array $data = [])
    {
        $this->name = isset($data["name"]) ? $data["name"] : null;
        $this->score = isset($data["score"]) ? $data["score"] : null;
        $this->reason = isset($data["reason"]) ? $data["reason"] : null;
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}