<?php

namespace Intergo\ServiceKycClient\DataTransferObjects;

class DecisionLogicDTO
{
    /** @var string|null */
    public ?string $id = null;

    /** @var string|null */
    public ?string $decision = null;

    /** @var float|null */
    public ?float $maxScore = null;

    /** @var float|null */
    public ?float $minScore = null;

    /**
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->id = $data["id"] ?? null;
        $this->decision = $data["decision"] ?? null;
        $this->maxScore = $data["maxScore"] ?? null;
        $this->minScore = $data["minScore"] ?? null;
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return get_object_vars($this);
    }
}
