<?php

namespace Intergo\ServiceKycClient\DataTransferObjects;

use Intergo\ServiceKycClient\DataTransferObjects\ScoreItemDTO;

class QualificationResultDTO
{
    /** @var int|null */
    public ?int $qualificationId = null;

    /** @var ScoreItemDTO[]|null */
    public ?array $scoreItems = null;

    /** @var string|null */
    public ?string $status = null;

    /** @var int|null */
    public ?int $totalScore = null;

    /** @var int|null */
    public ?int $maxScore = null;

    /** @var string|null */
    public ?string $decision = null;

    /** @var string|null */
    public ?string $trustLevel = null;

    /** @var string|null */
    public ?string $traceId = null;

    public function __construct(array $data = [])
    {
        $this->qualificationId = $data["qualificationId"] ?? null;
        if (isset($data["scoreItems"]) && is_array($data["scoreItems"])) {
            $this->scoreItems = [];
            foreach ($data["scoreItems"] as $item) {
                $this->scoreItems[] = new ScoreItemDTO($item);
            }
        } else {
            $this->scoreItems = [];
        }
        $this->status = $data["status"] ?? null;
        $this->totalScore = $data["totalScore"] ?? null;
        $this->maxScore = $data["maxScore"] ?? null;
        $this->decision = $data["decision"] ?? null;
        $this->trustLevel = $data["trustLevel"] ?? null;
        $this->traceId = $data["traceId"] ?? null;
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}