<?php

namespace Intergo\ServiceKycClient\DataTransferObjects;

class QualificationDTO
{
    /** @var int|null */
    public ?int $qualificationId = null;

    /** @var string|null */
    public ?string $userName = null;

    /** @var string|null */
    public ?string $userEmail = null;

    /** @var string|null */
    public ?string $companyWebsite = null;

    /** @var string|null */
    public ?string $companyName = null;

    /** @var string|null */
    public ?string $productName = null;

    /** @var string|null */
    public ?string $userMessage = null;

    /** @var string|null */
    public ?string $facebook = null;

    /** @var string|null */
    public ?string $linkedin = null;

    /** @var string|null */
    public ?string $industry = null;

    /** @var string|null */
    public ?string $traffic = null;

    /** @var ?array|[] */
    public ?array $countriesOfInterest = [];

    /** @var string|null */
    public ?string $phoneCountry = null;

    /** @var string|null */
    public ?string $apiUsage = null;

    /** @var string|null */
    public ?string $trace_id = null;

    public function __construct(array $data = [])
    {
        $this->qualificationId = $data["qualificationId"] ?? null;
        $this->userName = $data["userName"] ?? null;
        $this->userEmail = $data["userEmail"] ?? null;
        $this->companyWebsite = $data["companyWebsite"] ?? null;
        $this->companyName = $data["companyName"] ?? null;
        $this->productName = $data["productName"] ?? null;
        $this->userMessage = $data["userMessage"] ?? null;
        $this->facebook = $data["facebook"] ?? null;
        $this->linkedin = $data["linkedin"] ?? null;
        $this->industry = $data["industry"] ?? null;
        $this->traffic = $data["traffic"] ?? null;
        $this->countriesOfInterest = $data["countriesOfInterest"] ?? [];
        $this->phoneCountry = $data["phoneCountry"] ?? null;
        $this->apiUsage = $data["apiUsage"] ?? null;
        $this->trace_id = $data["trace_id"] ?? null;
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}