<?php

namespace Intergo\ServiceKycClient\DataTransferObjects;

use Intergo\ServiceKycClient\DataTransferObjects\QualificationResultDTO;
use Intergo\ServiceKycClient\DataTransferObjects\QualificationDTO;

class RequestDTO
{
    /** @var string|null */
    public ?string $id = null;

    /** @var QualificationDTO|null */
    public $qualification = null;

    /** @var string|null */
    public ?string $prompt = null;

    /** @var QualificationResultDTO|null */
    public $qualificationResult = null;

    /** @var \DateTime|null */
    public ?\DateTime $createdAt = null;

    /** @var \DateTime|null */
    public ?\DateTime $updatedAt = null;

    public function __construct(array $data = [])
    {
        $this->id = $data["id"] ?? null;
        $this->qualification = new QualificationDTO($data["qualification"] ?? []);
        $this->prompt = $data["prompt"] ?? null;
        $this->qualificationResult = new QualificationResultDTO($data["qualificationResult"] ?? []);
        $this->createdAt = $data["createdAt"] ?? null;
        $this->updatedAt = $data["updatedAt"] ?? null;
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}