<?php

namespace Intergo\ServiceCampaignClient\DataTransferObjects;

class RequestPaginatedDTO
{
    /** @var RequestDTO|null */
    public ?array $requests = null;

    /** @var int|null */
    public ?int $totalPages = null;

    /** @var int|null */
    public ?int $page = null;

    public function __construct(array $data = [])
    {
        for ($i = 0; $i < count($data["requests"] ?? []); $i++) {
            $this->requests[] = new RequestDTO($data["requests"][$i] ?? []);
        }
        $this->totalPages = $data["totalPages"] ?? null;
        $this->page = $data["page"] ?? null;
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}