<?php

namespace Intergo\ServiceCampaignClient\DataTransferObjects;

use Intergo\ServiceCampaignClient\DataTransferObjects\MessageResultDTO;
use Intergo\ServiceCampaignClient\DataTransferObjects\MessageDTO;

class RequestDTO
{
    /** @var string|null */
    public ?string $id = null;

    /** @var MessageDTO|null */
    public $message = null;

    /** @var string|null */
    public ?string $prompt = null;

    /** @var MessageResultDTO|null */
    public $messageResult = null;

    /** @var \DateTime|null */
    public ?\DateTime $createdAt = null;

    /** @var \DateTime|null */
    public ?\DateTime $updatedAt = null;

    public function __construct(array $data = [])
    {
        $this->id = $data["id"] ?? null;
        $this->message = new MessageDTO($data["message"] ?? []);
        $this->prompt = $data["prompt"] ?? null;
        $this->messageResult = new MessageResultDTO($data["messageResult"] ?? []);
        $this->createdAt = $data["createdAt"] ?? null;
        $this->updatedAt = $data["updatedAt"] ?? null;
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}