<?php

namespace Intergo\ServiceCampaignClient\DataTransferObjects;

use Intergo\ServiceCampaignClient\DataTransferObjects\ScoreItemDTO;

class MessageResultDTO
{
    /** @var int|null */
    public ?int $pendingMessageId = null;

    /** @var ScoreItemDTO[]|null */
    public ?array $scoreItems = null;

    /** @var string|null */
    public ?string $status = null;

    /** @var float|null */
    public ?float $totalScore = null;

    /** @var float|null */
    public ?float $maxScore = null;
    
    /** @var string|null */
    public ?string $decision = null;

    /** @var string|null */
    public ?string $traceId = null;

    /** @var string|null */
    public ?string $trustAdjustmentResult = null;

    /** @var string|null */
    public ?string $trustAdjustmentReason = null;

    /** @var string|null */
    public ?string $trustAdjustmentDate = null;

    public function __construct(array $data = [])
    {
        $this->pendingMessageId = $data["pendingMessageId"] ?? null;
        if (isset($data["scoreItems"]) && is_array($data["scoreItems"])) {
            $this->scoreItems = [];
            foreach ($data["scoreItems"] as $item) {
                $this->scoreItems[] = new ScoreItemDTO($item);
            }
        } else {
            $this->scoreItems = [];
        }
        $this->status = $data["status"] ?? null;
        $this->totalScore = $data["totalScore"] ?? null;
        $this->maxScore = $data["maxScore"] ?? null;
        $this->decision = $data["decision"] ?? null;
        $this->traceId = $data["traceId"] ?? null;
        $this->trustAdjustmentResult = $data["trustAdjustmentResult"] ?? null;
        $this->trustAdjustmentReason = $data["trustAdjustmentReason"] ?? null;
        $this->trustAdjustmentDate = $data["trustAdjustmentDate"] ?? null;
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}